/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.oceansdelight.datagen;

import com.mojang.logging.LogUtils;
import com.scouter.oceansdelight.blocks.ODBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class BlockstateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockstateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "oceansdelight", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("oceansdelight", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.feastBlock((FeastBlock)ODBlocks.GUARDIAN_SOUP.get());
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.m_61143_((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.m_6908_().toArray().length - 2);
            }
            ConfiguredModel.Builder var10000 = ConfiguredModel.builder();
            String var10002 = this.blockName((Block)block);
            return var10000.modelFile(this.existingModel(var10002 + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)FeastBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
    }

    public String m_6055_() {
        return "Block States: oceansdelight";
    }
}

